<?php


use App\Http\Controllers\AuthController;
use App\Http\Controllers\BdgtSpentController;
use App\Http\Controllers\DiscCondMastController;
use App\Http\Controllers\DiscCrieteriaController;
use App\Http\Controllers\DiscountMasterController;
use App\Http\Controllers\DiscountTypeController;
use App\Http\Controllers\DiscUnitController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\EventMemberController;
use App\Http\Controllers\EventTypeController;
use App\Http\Controllers\EvTaskController;
use App\Http\Controllers\ExcelUploadApiController;
use App\Http\Controllers\FunctionTypeController;
use App\Http\Controllers\GrMasterController;
use App\Http\Controllers\HeadFamilyController;
use App\Http\Controllers\ModuleMasterController;
use App\Http\Controllers\NewFunctionTypeController;
use App\Http\Controllers\NoticeboardController;
use App\Http\Controllers\PackageMasterController;
use App\Http\Controllers\PackageModuleLinkController;
use App\Http\Controllers\PlannerController;
use App\Http\Controllers\RelationController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\StatusMasterController;
use App\Http\Controllers\SuggestionMasterController;
use App\Http\Controllers\TaskBdgtController;
use App\Http\Controllers\TaskGallaryController;
use App\Http\Controllers\TaskMemberController;
use App\Http\Controllers\TaskPlannerController;
use App\Http\Controllers\TaskReqController;
use App\Http\Controllers\TpqAnswerController;
use App\Http\Controllers\TpsMemrepController;
use App\Http\Controllers\TpSuggestionController;
use App\Http\Controllers\UserMasterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;



/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::apiResource('roles', RoleController::class);


Route::get('/user-masters', [UserMasterController::class, 'index']);
Route::post('/user-masters',  [UserMasterController::class, 'store']);
Route::get('/user-masters/{id}', [UserMasterController::class, 'show']);
Route::put('/user-masters/{id}',  [UserMasterController::class, 'update']);
Route::delete('/user-masters/{id}', [UserMasterController::class, 'destroy']);


Route::post('/login', [UserMasterController::class, 'login']);


Route::get('/events', [EventController::class, 'index']);
Route::post('/events', [EventController::class, 'store']);
Route::get('/events/{id}', [EventController::class, 'show']);
Route::put('/events/{id}', [EventController::class, 'update']);
Route::delete('/events/{id}', [EventController::class, 'destroy']);



Route::get('/event-members', [EventMemberController::class, 'index']);
Route::post('/event-members', [EventMemberController::class, 'store']);
Route::get('/event-members/{id}', [EventMemberController::class, 'show']);
Route::put('/event-members/{id}', [EventMemberController::class, 'update']);
Route::delete('/event-members/{id}', [EventMemberController::class, 'destroy']);



Route::get('/noticeboards', [NoticeboardController::class, 'index']);
Route::post('/noticeboards', [NoticeboardController::class, 'store']);
Route::get('/noticeboards/{id}', [NoticeboardController::class, 'show']);
Route::put('/noticeboards/{id}', [NoticeboardController::class, 'update']);
Route::delete('/noticeboards/{id}', [NoticeboardController::class, 'destroy']);




Route::get('/ev-tasks', [EvTaskController::class, 'index']);
Route::post('/ev-tasks', [EvTaskController::class, 'store']);
Route::get('/ev-tasks/{id}', [EvTaskController::class, 'show']);
Route::put('/ev-tasks/{id}', [EvTaskController::class, 'update']);
Route::delete('/ev-tasks/{id}', [EvTaskController::class, 'destroy']);



Route::get('task-members', [TaskMemberController::class, 'index']);
Route::post('task-members', [TaskMemberController::class, 'store']);
Route::get('task-members/{id}', [TaskMemberController::class, 'show']);
Route::put('task-members/{id}', [TaskMemberController::class, 'update']);
Route::delete('task-members/{id}', [TaskMemberController::class, 'destroy']);



Route::get('task-planners', [TaskPlannerController::class, 'index']);
Route::post('task-planners', [TaskPlannerController::class, 'store']);
Route::get('task-planners/{id}', [TaskPlannerController::class, 'show']);
Route::put('task-planners/{id}', [TaskPlannerController::class, 'update']);
Route::delete('task-planners/{id}', [TaskPlannerController::class, 'destroy']);



Route::get('tp-suggestions', [TpSuggestionController::class, 'index']);
Route::post('tp-suggestions', [TpSuggestionController::class, 'store']);
Route::get('tp-suggestions/{id}', [TpSuggestionController::class, 'show']);
Route::put('tp-suggestions/{id}', [TpSuggestionController::class, 'update']);
Route::delete('tp-suggestions/{id}', [TpSuggestionController::class, 'destroy']);



Route::get('tpq-answers', [TpqAnswerController::class, 'index']);
Route::post('tpq-answers', [TpqAnswerController::class, 'store']);
Route::get('tpq-answers/{id}', [TpqAnswerController::class, 'show']);
Route::put('tpq-answers/{id}', [TpqAnswerController::class, 'update']);
Route::delete('tpq-answers/{id}', [TpqAnswerController::class, 'destroy']);



Route::get('tps-memreps', [TpsMemrepController::class, 'index']);
Route::post('tps-memreps', [TpsMemrepController::class, 'store']);
Route::get('tps-memreps/{id}', [TpsMemrepController::class, 'show']);
Route::put('tps-memreps/{id}', [TpsMemrepController::class, 'update']);
Route::delete('tps-memreps/{id}', [TpsMemrepController::class, 'destroy']);



Route::get('gr-masters', [GrMasterController::class, 'index']);          // Get all
Route::get('gr-masters/{id}', [GrMasterController::class, 'show']);      // Get one
Route::post('gr-masters', [GrMasterController::class, 'store']);         // Create
Route::put('gr-masters/{id}', [GrMasterController::class, 'update']);    // Update
Route::delete('gr-masters/{id}', [GrMasterController::class, 'destroy']);



Route::get('task-reqs', [TaskReqController::class, 'index']);          // Get all
Route::get('task-reqs/{id}', [TaskReqController::class, 'show']);      // Get one
Route::post('task-reqs', [TaskReqController::class, 'store']);         // Create
Route::put('task-reqs/{id}', [TaskReqController::class, 'update']);    // Update
Route::delete('task-reqs/{id}', [TaskReqController::class, 'destroy']);




Route::get('task-bdgts', [TaskBdgtController::class, 'index']);
Route::get('task-bdgts/{id}', [TaskBdgtController::class, 'show']);
Route::post('task-bdgts', [TaskBdgtController::class, 'store']);
Route::put('task-bdgts/{id}', [TaskBdgtController::class, 'update']);
Route::delete('task-bdgts/{id}', [TaskBdgtController::class, 'destroy']);



Route::get('/bdgt-spents', [BdgtSpentController::class, 'index']);
Route::post('/bdgt-spents', [BdgtSpentController::class, 'store']);
Route::get('/bdgt-spents/{id}', [BdgtSpentController::class, 'show']);
Route::put('/bdgt-spents/{id}', [BdgtSpentController::class, 'update']);
Route::delete('/bdgt-spents/{id}', [BdgtSpentController::class, 'destroy']);




Route::get('/task-gallary', [TaskGallaryController::class, 'index']);
Route::post('/task-gallary', [TaskGallaryController::class, 'store']);
Route::get('/task-gallary/{id}', [TaskGallaryController::class, 'show']);
Route::put('/task-gallary/{id}', [TaskGallaryController::class, 'update']);
Route::delete('/task-gallary/{id}', [TaskGallaryController::class, 'destroy']);
Route::delete('task-gallary/{id}/image/{index}', [TaskGallaryController::class, 'deleteImage']);
Route::put('task-gallary/{id}/image/{index}', [TaskGallaryController::class, 'updateImageByIndex']);
Route::post('task-gallary/{id}/image/add', [TaskGallaryController::class, 'addImages']);




Route::post('forgot-password', [AuthController::class, 'sendOtp']);
Route::post('verify-otp', [AuthController::class, 'verifyOtp']);
Route::post('reset-password', [AuthController::class, 'resetPassword']);





Route::get('event-types', [EventTypeController::class, 'index']);
Route::get('event-types/{id}', [EventTypeController::class, 'show']);
Route::post('event-types', [EventTypeController::class, 'store']);
Route::put('event-types/{id}', [EventTypeController::class, 'update']);
Route::delete('event-types/{id}', [EventTypeController::class, 'destroy']);



Route::get('function-types', [FunctionTypeController::class, 'index']);         // GET all
Route::get('function-types/{id}', [FunctionTypeController::class, 'show']);     // GET one
Route::post('function-types', [FunctionTypeController::class, 'store']);        // CREATE
Route::put('function-types/{id}', [FunctionTypeController::class, 'update']);   // UPDATE
Route::delete('function-types/{id}', [FunctionTypeController::class, 'destroy']); // DELETE



Route::get('planners', [PlannerController::class, 'index']);
Route::get('planners/{id}', [PlannerController::class, 'show']);
Route::post('planners', [PlannerController::class, 'store']);
Route::put('planners/{id}', [PlannerController::class, 'update']);
Route::delete('planners/{id}', [PlannerController::class, 'destroy']);



Route::get('relations', [RelationController::class, 'index']);
Route::get('relations/{id}', [RelationController::class, 'show']);
Route::post('relations', [RelationController::class, 'store']);
Route::put('relations/{id}', [RelationController::class, 'update']);
Route::delete('relations/{id}', [RelationController::class, 'destroy']);
// Route::delete('relations/{id}', [RelationController::class, 'destroy'])->middleware(['auth:sanctum', 'only.superadmin']);;






Route::apiResource('statuses', StatusMasterController::class);


Route::apiResource('new-function-types', NewFunctionTypeController::class);



Route::apiResource('packages', PackageMasterController::class);


Route::apiResource('modules', ModuleMasterController::class);

Route::apiResource('package-module-links', PackageModuleLinkController::class);


Route::apiResource('discount-types', DiscountTypeController::class);


Route::apiResource('disc-crieterias', DiscCrieteriaController::class);


Route::apiResource('disc-units', DiscUnitController::class);


Route::apiResource('disc-cond-mast', DiscCondMastController::class);


Route::apiResource('discount-masters', DiscountMasterController::class);




Route::get('/suggestion-masters', [SuggestionMasterController::class, 'index']);         // Get all
Route::get('/suggestion-masters/{id}', [SuggestionMasterController::class, 'show']);      // Get one
Route::post('/suggestion-masters', [SuggestionMasterController::class, 'store']);         // Create
Route::put('/suggestion-masters/{id}', [SuggestionMasterController::class, 'update']);    // Update
Route::delete('/suggestion-masters/{id}', [SuggestionMasterController::class, 'destroy']); // Delete




// Route::post('/upload-user-excel', [ExcelUploadApiController::class, 'upload']);

// Route::post('/users/send-emails', [UserMasterController::class, 'sendEmailsFromExcel']);
Route::post('/users/import', [UserMasterController::class, 'importUsers']);
