<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('discount_masters', function (Blueprint $table) {
            $table->bigIncrements('DiscID');

            $table->unsignedBigInteger('DiscTID')->nullable(); // FK to discount_types
            $table->string('DiscountName')->nullable();

            $table->unsignedBigInteger('DiscCriID')->nullable(); // FK to disc_crieterias
            $table->decimal('Cri_Vale', 10, 2)->nullable();
            $table->decimal('Disc_Value', 10, 2)->nullable();
            $table->string('Disc_Desc')->nullable();

            $table->unsignedBigInteger('DiscUId')->nullable(); // FK to disc_units
            $table->dateTime('D_Valid_From')->nullable();
            $table->dateTime('D_Valid_To')->nullable();
            $table->string('D_Apply_To',)->nullable();
            $table->string('Disc_Clubbed', 1)->nullable();
            $table->tinyInteger('Status')->default(1);

            // Proper FK references with actual PK column names
            $table->foreign('DiscTID')->references('DiscTID')->on('discount_types')->onDelete('set null');
            $table->foreign('DiscCriID')->references('DiscCriID')->on('disc_crieterias')->onDelete('set null');
            $table->foreign('DiscUId')->references('DiscUID')->on('disc_units')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('discount_masters');
    }
};
