<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_module_links', function (Blueprint $table) {
            $table->bigIncrements('PMLinkID');
            $table->unsignedBigInteger('PackageID')->nullable();
            $table->unsignedBigInteger('ModuleID')->nullable();
            $table->decimal('ModuleFixPrice', 10, 2)->nullable();
            $table->integer('ModuleFreeUsers')->nullable();
            $table->decimal('ExtraUserFees', 10, 2)->nullable();
            $table->integer('MarginShare')->nullable();
            $table->timestamps();

            // Foreign keys (assumes PackageMaster & ModuleMaster tables exist)
            $table->foreign('PackageID')->references('PackageId')->on('package_masters')->onDelete('set null');
            $table->foreign('ModuleID')->references('ModuleID')->on('module_masters')->onDelete('set null');
        });
    }

    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_module_links');
    }
};
