<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_masters', function (Blueprint $table) {
            $table->bigIncrements('PackageId');
            $table->string('PackageName')->nullable();
            $table->string('Description')->nullable();
            $table->tinyInteger('Status')->default(1);
            $table->decimal('PackFixPrice', 10, 2)->nullable();
            $table->integer('PackFreeUsers')->nullable();
            $table->decimal('ExtraUserFees', 10, 2)->nullable();
            $table->integer('ValidityDays')->nullable();
            $table->string('AutoRenew', 1)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_masters');
    }
};
