<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('new_function_types', function (Blueprint $table) {
            $table->id();
            $table->string('desc')->nullable();
            $table->foreignId('ev_type_id')->nullable()->constrained('event_types')->onDelete('set null');
            $table->string('Upgrp')->nullable();
            $table->string('Grcod')->nullable();
            $table->string('Grsrn')->nullable();
            $table->string('Grsh')->nullable();
            $table->foreignId('func_id')->nullable()->constrained('function_types')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('new_function_types');
    }
};
