<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('function_types', function (Blueprint $table) {
            $table->foreignId('func_id')
                ->nullable()
                ->constrained('function_types') // references the same table
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('function_types', function (Blueprint $table) {
            $table->dropForeign(['func_id']);
            $table->dropColumn('func_id');
        });
    }
};
