<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('task_planner', function (Blueprint $table) {
            // Make TP_Name nullable
            $table->string('TP_Name')->nullable()->change();

            // Add nullable plan_id foreign key
            $table->foreignId('plan_id')->nullable()->constrained('planners')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('task_planner', function (Blueprint $table) {
            // Rollback logic
            $table->string('TP_Name')->nullable(false)->change();
            $table->dropForeign(['plan_id']);
            $table->dropColumn('plan_id');
        });
    }
};
