<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ev_tasks', function (Blueprint $table) {
            $table->dropForeign(['user_id']);

            // Then, drop the column
            $table->dropColumn('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ev_tasks', function (Blueprint $table) {
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('user_masters')
                ->onDelete('set null');
        });
    }
};
