<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_members', function (Blueprint $table) {
            $table->dropForeign(['user_id']); // drop foreign key first
            $table->dropColumn('user_id');    // drop existing column
        });

        Schema::table('event_members', function (Blueprint $table) {
            $table->longText('user_id')->nullable(); // recreate as longText
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_members', function (Blueprint $table) {
            $table->dropColumn('user_id');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('user_masters')->onDelete('set null');
        });
    }
};
