<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_masters', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->nullable()->after('role_id');
            $table->unsignedBigInteger('relation_id')->nullable()->after('user_id');

            $table->foreign('user_id')->references('id')->on('user_masters')->onDelete('set null');
            $table->foreign('relation_id')->references('id')->on('relations')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_masters', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['relation_id']);
            $table->dropColumn(['user_id', 'relation_id']);
        });
    }
};
