<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->unsignedBigInteger('ev_type_id')->nullable()->after('user_id');
            $table->foreign('ev_type_id')->references('id')->on('event_types')->onDelete('set null');

            // Add other fields
            $table->longText('image')->nullable()->after('ev_type_id');
            $table->integer('expected_guests')->nullable()->after('image');
            $table->string('location')->nullable()->after('expected_guests');
            $table->string('description')->nullable()->after('location');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->dropForeign(['ev_type_id']);
            $table->dropColumn(['ev_type_id', 'image', 'expected_guests', 'location', 'description']);
        });
    }
};
