<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_gallary', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_member_id')->nullable()->constrained('task_members')->onDelete('cascade');
            $table->longText('Image')->nullable();
            $table->dateTime('Img_Date')->nullable();
            $table->string('Img_GPS')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_gallary');
    }
};
