<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bdgt_spents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_bdgt_id')->constrained('task_bdgts')->onDelete('cascade');
            $table->decimal('Spnt_Amount', 8, 2);
            $table->dateTime('Spnt_Date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bdgt_spents');
    }
};
