<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_bdgts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ev_task_id')->nullable()->constrained('ev_tasks')->onDelete('set null');
            $table->decimal('Est_Amount', 8, 2);
            $table->dateTime('Est_Date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_bdgts');
    }
};
