<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_reqs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ev_task_id')->constrained('ev_tasks')->onDelete('cascade');;
            $table->foreignId('gr_master_id')->nullable()->constrained('gr_masters')->onDelete('cascade');;

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_reqs');
    }
};
