<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tps_memreps', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_member_id')->nullable()->constrained('task_members')->onDelete('cascade');
            $table->foreignId('task_planner_id')->nullable()->constrained('task_planner')->onDelete('cascade');
            $table->foreignId('tp_suggestion_id')->nullable()->constrained('tp_suggestions')->onDelete('cascade');
            $table->foreignId('tpq_answer_id')->nullable()->constrained('tpq_answers')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tps_memreps');
    }
};
