<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tpq_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tp_suggestion_id')->nullable()->constrained('tp_suggestions')->onDelete('cascade');
            $table->string('TP_Answer');
            $table->longText('TPA_Image')->nullable();
            $table->integer('TPA_Option')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tpq_answers');
    }
};
