<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tp_suggestions', function (Blueprint $table) {
            $table->id();
            $table->string('TPS_Question');
            $table->longText('TPS_Image')->nullable();
            $table->foreignId('task_planner_id')->nullable()->constrained('task_planner')->onDelete('cascade');
            $table->tinyInteger('TPS_Status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tp_suggestions');
    }
};
