<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_planner', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ev_task_id')->nullable()->constrained('ev_tasks')->onDelete('cascade');
            $table->string('TP_Name');
            $table->string('TP_Type')->nullable();
            $table->dateTime('TP_TimeLine')->nullable();
            $table->tinyInteger('TP_Status')->default(0);
            $table->foreignId('task_member_id')->nullable()->constrained('task_members')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_planner');
    }
};
