<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_member_id')->constrained('event_members')->onDelete('cascade');
            $table->dateTime('Task_Invite')->nullable();
            $table->dateTime('Task_Accept')->nullable();
            $table->tinyInteger('TM_Status')->default(0);
            $table->foreignId('ev_task_id')->constrained('ev_tasks')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_members');
    }
};
