<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('noticeboards', function (Blueprint $table) {
            $table->id();
            $table->string('Ntc_Title');
            $table->text('NTC_Desc')->nullable();
            $table->integer('Severity')->nullable();
            $table->foreignId('event_id')->nullable()->constrained('events')->nullOnDelete();
            $table->dateTime('Ntc_S_Dt')->nullable();
            $table->dateTime('NTC_E_Dt')->nullable();
            $table->tinyInteger('NTC_Status')->default(0);
            $table->longText('NTC_Image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('noticeboards');
    }
};
