<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class CustomWelcomeEmail extends Notification
{
    use Queueable;

    protected $name;
    protected $link;

    public function __construct($name, $link)
    {
        $this->name = $name;
        $this->link = $link;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Welcome, ' . $this->name)
            ->greeting('Hi ' . $this->name . ',')
            ->line('We’re excited to have you onboard.')
            ->action('Go to Login', $this->link)
            ->line('Thank you!');
    }
}
