<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\HasApiTokens;

class UserMaster extends Model
{
    use HasFactory, HasApiTokens;
    protected $fillable = [
        'name',
        'email',
        'mobile',
        'password',
        'image',
        'role_id',
        'user_id',
        'relation_id',
        'U_Status',
        'PackageId'
    ];
    // protected $hidden = ['password'];

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::needsRehash($value)
            ? Hash::make($value)
            : $value;
    }

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

    public function parentUser()
    {
        return $this->belongsTo(UserMaster::class, 'user_id');
    }

    public function relation()
    {
        return $this->belongsTo(Relation::class, 'relation_id');
    }


    public function package()
    {
        return $this->belongsTo(PackageMaster::class, 'PackageId');
    }
}
