<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TpsMemrep extends Model
{
    use HasFactory;

    protected $fillable = [
        'task_member_id',
        'task_planner_id',
        'tp_suggestion_id',
        'tpq_answer_id',
    ];

    public function taskMember()
    {
        return $this->belongsTo(TaskMember::class);
    }

    public function taskPlanner()
    {
        return $this->belongsTo(TaskPlanner::class);
    }

    public function suggestion()
    {
        return $this->belongsTo(TpSuggestion::class, 'tp_suggestion_id');
    }

    public function answer()
    {
        return $this->belongsTo(TpqAnswer::class, 'tpq_answer_id');
    }
}
