<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TpSuggestion extends Model
{

    use HasFactory;
    protected $fillable = [
        'TPS_Question',
        'TPS_Image',
        'task_planner_id',
        'TPS_Status',
    ];

    protected $casts = [

        'TPS_Image' => 'array',
    ];

    public function taskPlanner()
    {
        return $this->belongsTo(TaskPlanner::class, 'task_planner_id');
    }
}
