<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaskReq extends Model
{
    use HasFactory;
    protected $fillable = [
        'ev_task_id',
        'gr_master_id',
    ];

    // Optional relationships
    public function evTask()
    {
        return $this->belongsTo(EvTask::class, 'ev_task_id');
    }

    public function grMaster()
    {
        return $this->belongsTo(GrMaster::class, 'gr_master_id');
    }
}
