<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaskPlanner extends Model
{
    use HasFactory;
    protected $table = 'task_planner';

    protected $fillable = [
        'ev_task_id',
        'TP_Name',
        'TP_Type',
        'TP_TimeLine',
        'TP_Status',
        'task_member_id',
        'tp_user_statuses',
        'plan_id', // ✅ Added

    ];

    public function evTask()
    {
        return $this->belongsTo(EvTask::class, 'ev_task_id');
    }

    public function taskMember()
    {
        return $this->belongsTo(TaskMember::class, 'task_member_id');
    }
    protected $casts = [
        'tp_user_statuses' => 'array',
    ];

    public function planner()
    {
        return $this->belongsTo(Planner::class, 'plan_id'); // ✅ Added
    }
}
