<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TaskMember extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_member_id',
        'Task_Invite',
        'Task_Accept',
        'TM_Status',
        'ev_task_id',
        'user_statuses',
        'user_id', // ✅ add this
    ];

    protected $casts = [
        'user_statuses' => 'array',
        'user_id' => 'array', // ✅ cast as array
    ];

    public function eventMember()
    {
        return $this->belongsTo(EventMember::class);
    }

    public function task()
    {
        return $this->belongsTo(EvTask::class, 'ev_task_id');
    }

    public function taskPlanners()
    {
        return $this->hasMany(TaskPlanner::class, 'task_member_id');
    }
}
