<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Noticeboard extends Model
{
    use HasFactory;

    protected $fillable = [
        'Ntc_Title',
        'NTC_Desc',
        'Severity',
        'event_id',
        'Ntc_S_Dt',
        'NTC_E_Dt',
        'NTC_Status',
        'NTC_Image',
    ];

    protected $casts = [
        'NTC_Image' => 'array',
    ];
    
    public function event()
    {
        return $this->belongsTo(Event::class, 'event_id');
    }
}
