<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\UserMaster;
use App\Models\Event;

class EventMember extends Model
{
    protected $fillable = [
        'event_id',
        'user_id',
        'EM_Invite',
        'EM_Accept',
        'EM_Status',
    ];

    // protected $casts = [
    //     'user_id' => 'array',
    //     'EM_Invite' => 'datetime',
    //     'EM_Accept' => 'datetime',
    // ];

    // public function event()
    // {
    //     return $this->belongsTo(Event::class, 'event_id', 'id');
    // }

    // /**
    //  * Return all users where id is in user_id array
    //  */
    // public function users()
    // {
    //     return UserMaster::whereIn('id', $this->user_id ?? [])->get();
    // }


    protected $casts = [
        'user_id' => 'array', // now storing array of objects
        'EM_Invite' => 'datetime',
        'EM_Accept' => 'datetime',
    ];

    public function event()
    {
        return $this->belongsTo(Event::class, 'event_id');
    }

    // public function users()
    // {
    //     $ids = collect($this->user_id)->pluck('user_id')->toArray();
    //     return UserMaster::whereIn('id', $ids)->get();
    // }
    // public function getUsers()
    // {
    //     $ids = collect($this->user_id)->pluck('user_id')->unique()->toArray();
    //     return UserMaster::whereIn('id', $ids)->get();
    // }

    public function getUsers()
    {
        // Make sure $this->user_id is the full array like:
        // [ ['user_id' => 2, 'UM_Status' => 0], ... ]
        $userIds = collect($this->user_id)->pluck('user_id')->filter()->unique();

        return \App\Models\UserMaster::whereIn('id', $userIds)->get();
    }
}
