<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Event extends Model
{
    use HasFactory;

    protected $fillable = [
        'Ev_Name',
        'Ev_Date',
        'user_id',
        'ev_type_id',
        'image',
        'expected_guests',
        'location',
        'description',
    ];

    protected $casts = [
        'image' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(UserMaster::class, 'user_id');
    }

    public function eventType()
    {
        return $this->belongsTo(EventType::class, 'ev_type_id');
    }
}
