<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EvTask extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',

        'Task_Name',
        'Task_Date',
        'Task_Till',
        'Task_Venue',
        'Task_GPS',
        'description',
        'fun_type',

        'Upgrp',
        'Grcod',
        'Grsrn',
        'Grsh',
        'Status', // ✅ Added
    ];
    protected $casts = [
        'fun_type' => 'integer', // ✅ Cast as integer instead of array

    ];

    protected $appends = [
        'fun_type_data', // ✅ Auto-include in JSON
    ];
    public function event()
    {
        return $this->belongsTo(Event::class);
    }
    public function getFunTypeDataAttribute()
    {
        if ($this->fun_type) {
            return FunctionType::where('id', $this->fun_type)->first();
        }
        return null;
    }
    // public function planner()
    // {
    //     return $this->belongsTo(Planner::class, 'plan_id');
    // }

    public function taskPlanners()
    {
        return $this->hasMany(TaskPlanner::class, 'ev_task_id');
    }


    // public function user()
    // {
    //     return $this->belongsTo(UserMaster::class, 'user_id'); // ✅ relationship
    // }
}
