<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'DiscID';
    public $timestamps = false;

    protected $fillable = [
        'DiscTID',
        'DiscountName',
        'DiscCriID',
        'Cri_Vale',
        'Disc_Value',
        'Disc_Desc',
        'DiscUId',
        'D_Valid_From',
        'D_Valid_To',
        'D_Apply_To',
        'Disc_Clubbed',
        'Status',
    ];

    // Relationships
    public function discountType()
    {
        return $this->belongsTo(DiscountType::class, 'DiscTID', 'DiscTID');
    }

    public function discCriteria()
    {
        return $this->belongsTo(DiscCrieteria::class, 'DiscCriID', 'DiscCriID');
    }

    public function discUnit()
    {
        return $this->belongsTo(DiscUnit::class, 'DiscUId', 'DiscUID');
    }
}
