<?php


namespace App\Imports;

use App\Models\UserMaster;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\UserImportedMail;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class SimpleUsersImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use SkipsFailures;

    public function model(array $row)
    {
        $data = [
            'name' => $row['name'] ?? null,
            'email' => $row['email'] ?? null,
            'mobile' => $row['mobile'] ?? null,
            'password' => Hash::make('12345678'),
            'role_id' => 4,
            'U_Status' => 1,
        ];

        if ($data['role_id'] == 1 && UserMaster::where('role_id', 1)->exists()) {
            return null;
        }

        $user = new UserMaster($data);

        // Send email only if email exists
        if (!empty($data['email'])) {
            Mail::to($data['email'])->send(new UserImportedMail($data));
        }

        return $user;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'email' => 'nullable|email|unique:user_masters,email',
            'mobile' => 'required|max:15|unique:user_masters,mobile',
        ];
    }

    public function customValidationMessages()
    {
        return [
            'name.required' => 'Name is required for each user.',
            'email.unique' => 'The email :input is already taken.',
            'mobile.required' => 'Mobile number is required for each user.',
            'mobile.unique' => 'The mobile number :input is already taken.',
            'mobile.max' => 'The mobile number must not exceed 15 characters.',
        ];
    }
}
