<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class OnlySuperAdmin
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::guard('sanctum')->user();

        if (!$user) {
            return response()->json([
                'error' => 'Only Super Admins can perform this action.'
            ], 403);
        }

        if ($user->role_id != 1) {
            return response()->json([
                'error' => 'Only Super Admins can perform this action.'
            ], 403);
        }

        return $next($request);
    }
}
