<?php

namespace App\Http\Controllers;

use App\Models\TaskReq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Throwable;

class TaskReqController extends Controller
{
    public function index()
    {
        return response()->json(TaskReq::with(['evTask', 'grMaster'])->get());
    }

    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'ev_task_id'    => 'required|exists:ev_tasks,id',
                'gr_master_id'  => 'nullable|exists:gr_masters,id',
            ]);

            $req = TaskReq::create($data);

            return response()->json(['message' => 'Created', 'data' => $req], 201);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('TaskReq Store Error: ' . $e->getMessage());
            return response()->json(['error' => 'Server Error'], 500);
        }
    }

    public function show($id)
    {
        $req = TaskReq::with(['evTask', 'grMaster'])->find($id);
        if (!$req) return response()->json(['message' => 'Not found'], 404);
        return response()->json($req);
    }

    public function update(Request $request, $id)
    {
        try {
            $req = TaskReq::find($id);
            if (!$req) return response()->json(['message' => 'Not found'], 404);

            $data = $request->validate([
                'ev_task_id'    => 'sometimes|nullable|exists:ev_tasks,id',
                'gr_master_id'  => 'sometimes|nullable|exists:gr_masters,id',
            ]);

            $req->update($data);
            return response()->json(['message' => 'Updated', 'data' => $req]);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('TaskReq Update Error: ' . $e->getMessage());
            return response()->json(['error' => 'Server Error'], 500);
        }
    }

    public function destroy($id)
    {
        $req = TaskReq::find($id);
        if (!$req) return response()->json(['message' => 'Not found'], 404);
        $req->delete();
        return response()->json(['message' => 'Deleted']);
    }
}
