<?php

namespace App\Http\Controllers;

use App\Models\TaskBdgt;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;

use Throwable;

class TaskBdgtController extends Controller
{
    public function index()
    {
        try {
            $budgets = TaskBdgt::with('evTask')->get();
            return response()->json($budgets, 200);
        } catch (\Throwable $e) {
            Log::error('TaskBdgt Index Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch data'], 500);
        }
    }


    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'ev_task_id'  => 'nullable|exists:ev_tasks,id',
                'Est_Amount'  => 'required|numeric',
                'Est_Date'    => 'nullable|date',
            ]);

            $bdgt = TaskBdgt::create($data);

            return response()->json(['message' => 'Budget created', 'data' => $bdgt], 201);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('Budget Store Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to create budget'], 500);
        }
    }

    public function show($id)
    {
        try {
            $budget = TaskBdgt::with('evTask')->find($id);
            if (!$budget) {
                return response()->json(['message' => 'Budget not found'], 404);
            }
            return response()->json($budget, 200);
        } catch (\Throwable $e) {
            Log::error('TaskBdgt Show Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch record'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $bdgt = TaskBdgt::find($id);
            if (!$bdgt) return response()->json(['message' => 'Budget not found'], 404);

            $data = $request->validate([
                'ev_task_id'  => 'sometimes|nullable|exists:ev_tasks,id',
                'Est_Amount'  => 'sometimes|nullable|numeric',
                'Est_Date'    => 'sometimes|nullable|date',
            ]);

            $bdgt->update($data);

            return response()->json(['message' => 'Budget updated', 'data' => $bdgt]);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('Budget Update Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to update budget'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $bdgt = TaskBdgt::find($id);
            if (!$bdgt) return response()->json(['message' => 'Budget not found'], 404);

            $bdgt->delete();

            return response()->json(['message' => 'Budget deleted']);
        } catch (Throwable $e) {
            Log::error('Budget Delete Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to delete budget'], 500);
        }
    }
}
