<?php


namespace App\Http\Controllers;

use App\Models\Relation;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Log;
use Throwable;

class RelationController extends Controller
{
    public function index()
    {
        try {
            $relations = Relation::all();
            return response()->json($relations);
        } catch (Throwable $e) {
            Log::error('Relation Index Error: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to fetch relations'], 500);
        }
    }


    public function show($id)
    {
        try {
            $relation = Relation::find($id);
            if (!$relation) return response()->json(['message' => 'Not found'], 404);
            return response()->json($relation);
        } catch (Throwable $e) {
            Log::error('Relation Show Error: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to fetch relation'], 500);
        }
    }


    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'relation_name' => 'nullable|string',
            ]);

            $relation = Relation::create($data);
            return response()->json(['message' => 'Created', 'data' => $relation], 201);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('Relation Store Error: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to create relation'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $relation = Relation::find($id);
            if (!$relation) return response()->json(['message' => 'Not found'], 404);

            $data = $request->validate([
                'relation_name' => 'sometimes|nullable|string',
            ]);

            $relation->update($data);
            return response()->json(['message' => 'Updated', 'data' => $relation]);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('Relation Update Error: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to update relation'], 500);
        }
    }

    // DELETE
    // public function destroy($id)
    // {
    //     try {
    //         $relation = Relation::find($id);
    //         if (!$relation) return response()->json(['message' => 'Not found'], 404);

    //         $relation->delete();
    //         return response()->json(['message' => 'Deleted']);
    //     } catch (Throwable $e) {
    //         Log::error('Relation Delete Error: ' . $e->getMessage());
    //         return response()->json(['error' => 'Unable to delete relation'], 500);
    //     }
    // }

    public function destroy($id)
    {
        try {
            $relation = Relation::find($id);

            if (!$relation) {
                return response()->json(['message' => 'Relation not found.'], 404);
            }

            $relation->delete();
            return response()->json(['message' => 'Relation deleted successfully.']);
        } catch (\Throwable $e) {
            Log::error('Relation Delete Error: ' . $e->getMessage());
            return response()->json(['error' => 'Unable to delete relation'], 500);
        }
    }
}
