<?php

// app/Http/Controllers/PackageModuleLinkController.php

namespace App\Http\Controllers;

use App\Models\PackageModuleLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PackageModuleLinkController extends Controller
{
    public function index()
    {
        $data = PackageModuleLink::with(['package', 'module'])->get();
        return response()->json($data);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'PackageID'        => 'nullable|exists:package_masters,PackageId',
            'ModuleID'         => 'nullable|exists:module_masters,ModuleID',
            'ModuleFixPrice'   => 'nullable|numeric',
            'ModuleFreeUsers'  => 'nullable|integer',
            'ExtraUserFees'    => 'nullable|numeric',
            'MarginShare'      => 'nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = PackageModuleLink::create($request->all());
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    public function show($id)
    {
        $data = PackageModuleLink::with(['package', 'module'])->find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function update(Request $request, $id)
    {
        $data = PackageModuleLink::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'PackageID'        => 'sometimes|nullable|exists:package_masters,PackageId',
            'ModuleID'         => 'sometimes|nullable|exists:module_masters,ModuleID',
            'ModuleFixPrice'   => 'sometimes|nullable|numeric',
            'ModuleFreeUsers'  => 'sometimes|nullable|integer',
            'ExtraUserFees'    => 'sometimes|nullable|numeric',
            'MarginShare'      => 'sometimes|nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data->update($request->all());
        return response()->json(['status' => true, 'data' => $data]);
    }

    public function destroy($id)
    {
        $data = PackageModuleLink::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $data->delete();
        return response()->json(['status' => true, 'message' => 'Deleted']);
    }
}
