<?php
// app/Http/Controllers/PackageMasterController.php

namespace App\Http\Controllers;

use App\Models\PackageMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PackageMasterController extends Controller
{
    // Get all packages
    public function index()
    {
        return response()->json(PackageMaster::all());
    }

    // Create new package
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'PackageName' => 'required|string',
            'Description' => 'nullable|string',
            'Status' => 'nullable|integer',
            'PackFixPrice' => 'nullable|numeric',
            'PackFreeUsers' => 'nullable|integer',
            'ExtraUserFees' => 'nullable|numeric',
            'ValidityDays' => 'nullable|integer',
            'AutoRenew' => 'nullable|string|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $package = PackageMaster::create($request->all());

        return response()->json(['status' => true, 'data' => $package], 201);
    }

    // Show single package
    public function show($id)
    {
        $package = PackageMaster::find($id);

        if (!$package) {
            return response()->json(['status' => false, 'message' => 'Package not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $package]);
    }

    // Update package
    public function update(Request $request, $id)
    {
        $package = PackageMaster::find($id);

        if (!$package) {
            return response()->json(['status' => false, 'message' => 'Package not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'PackageName' => 'sometimes|nullable|string',
            'Description' => 'sometimes|nullable|string',
            'Status' => 'sometimes|nullable|integer',
            'PackFixPrice' => 'sometimes|nullable|numeric',
            'PackFreeUsers' => 'sometimes|nullable|integer',
            'ExtraUserFees' => 'sometimes|nullable|numeric',
            'ValidityDays' => 'sometimes|nullable|integer',
            'AutoRenew' => 'sometimes|nullable|string|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $package->update($request->all());

        return response()->json(['status' => true, 'data' => $package]);
    }

    // Delete package
    public function destroy($id)
    {
        $package = PackageMaster::find($id);

        if (!$package) {
            return response()->json(['status' => false, 'message' => 'Package not found'], 404);
        }

        $package->delete();

        return response()->json(['status' => true, 'message' => 'Package deleted']);
    }
}
