<?php

// app/Http/Controllers/ModuleMasterController.php

namespace App\Http\Controllers;

use App\Models\ModuleMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ModuleMasterController extends Controller
{
    // Get all
    public function index()
    {
        return response()->json(ModuleMaster::all());
    }

    // Store new
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ModuleName'  => 'required|string',
            'Description' => 'nullable|string',
            'Status'      => 'nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = ModuleMaster::create($request->all());
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    // Show single
    public function show($id)
    {
        $data = ModuleMaster::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Module not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }

    // Update
    public function update(Request $request, $id)
    {
        $data = ModuleMaster::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Module not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'ModuleName'  => 'sometimes|nullable|string',
            'Description' => 'sometimes|nullable|string',
            'Status'      => 'sometimes|nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data->update($request->all());

        return response()->json(['status' => true, 'data' => $data]);
    }

    // Delete
    public function destroy($id)
    {
        $data = ModuleMaster::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Module not found'], 404);
        }

        $data->delete();
        return response()->json(['status' => true, 'message' => 'Module deleted']);
    }
}
