<?php

namespace App\Http\Controllers;

use App\Models\GrMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Throwable;

class GrMasterController extends Controller
{
    public function index()
    {
        return response()->json(GrMaster::all(), 200);
    }

    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'GR_Desc' => 'nullable|string',
                'GR_Mode' => 'nullable|string',
            ]);

            $gr = GrMaster::create($data);
            return response()->json(['message' => 'Created', 'data' => $gr], 201);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('GR Master Store Error: ' . $e->getMessage());
            return response()->json(['error' => 'Server error'], 500);
        }
    }

    public function show($id)
    {
        $gr = GrMaster::find($id);
        if (!$gr) return response()->json(['message' => 'Not found'], 404);
        return response()->json($gr);
    }

    public function update(Request $request, $id)
    {
        try {
            $gr = GrMaster::find($id);
            if (!$gr) return response()->json(['message' => 'Not found'], 404);

            $data = $request->validate([
                'GR_Desc' => 'sometimes|nullable|string',
                'GR_Mode' => 'sometimes|nullable|string',
            ]);

            $gr->update($data);
            return response()->json(['message' => 'Updated', 'data' => $gr], 200);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('GR Master Update Error: ' . $e->getMessage());
            return response()->json(['error' => 'Server error'], 500);
        }
    }

    public function destroy($id)
    {
        $gr = GrMaster::find($id);
        if (!$gr) return response()->json(['message' => 'Not found'], 404);

        $gr->delete();
        return response()->json(['message' => 'Deleted'], 200);
    }
}
