<?php

// app/Http/Controllers/DiscountTypeController.php

namespace App\Http\Controllers;

use App\Models\DiscountType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscountTypeController extends Controller
{
    public function index()
    {
        return response()->json(DiscountType::all());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'DiscountType' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = DiscountType::create($request->all());
        return response()->json(['status' => true, 'data' => $data], 201);
    }

    public function show($id)
    {
        $data = DiscountType::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function update(Request $request, $id)
    {
        $data = DiscountType::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'DiscountType' => 'sometimes|nullable|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data->update($request->all());

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function destroy($id)
    {
        $data = DiscountType::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $data->delete();
        return response()->json(['status' => true, 'message' => 'Deleted']);
    }
}
