<?php

namespace App\Http\Controllers;

use App\Models\DiscountMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscountMasterController extends Controller
{
    public function index()
    {
        $data = DiscountMaster::with(['discountType', 'discCriteria', 'discUnit'])->get();
        return response()->json($data);
    }

    public function show($id)
    {
        $data = DiscountMaster::with(['discountType', 'discCriteria', 'discUnit'])->find($id);
        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not Found'], 404);
        }
        return response()->json(['status' => true, 'data' => $data]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'DiscTID' => 'nullable|exists:discount_types,DiscTID',
            'DiscountName' => 'nullable|string',
            'DiscCriID' => 'nullable|exists:disc_crieterias,DiscCriID',
            'Cri_Vale' => 'nullable|numeric',
            'Disc_Value' => 'nullable|numeric',
            'Disc_Desc' => 'nullable|string',
            'DiscUId' => 'nullable|exists:disc_units,DiscUID',
            'D_Valid_From' => 'nullable|date',
            'D_Valid_To' => 'nullable|date',
            'D_Apply_To' => 'nullable|string',
            'Disc_Clubbed' => 'nullable|string|max:1',
            'Status' => 'nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = DiscountMaster::create($request->all());
        return response()->json(['status' => true, 'message' => 'Created successfully', 'data' => $data]);
    }

    public function update(Request $request, $id)
    {
        $data = DiscountMaster::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not Found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'DiscTID'       => 'sometimes|nullable|exists:discount_types,DiscTID',
            'DiscountName'  => 'sometimes|nullable|string|max:25',
            'DiscCriID'     => 'sometimes|nullable|exists:disc_crieterias,DiscCriID',
            'Cri_Vale'      => 'sometimes|nullable|numeric',
            'Disc_Value'    => 'sometimes|nullable|numeric',
            'Disc_Desc'     => 'sometimes|nullable|string',
            'DiscUId'       => 'sometimes|nullable|exists:disc_units,DiscUID',
            'D_Valid_From'  => 'sometimes|nullable|date',
            'D_Valid_To'    => 'sometimes|nullable|date',
            'D_Apply_To'    => 'sometimes|nullable|string',
            'Disc_Clubbed'  => 'sometimes|nullable|string|max:1',
            'Status'        => 'sometimes|nullable|integer',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        // Only update fields that are present in the request
        foreach ($request->all() as $key => $value) {
            if ($request->has($key)) {
                $data->$key = $value;
            }
        }

        $data->save();

        return response()->json(['status' => true, 'message' => 'Updated successfully', 'data' => $data]);
    }

    public function destroy($id)
    {
        $data = DiscountMaster::find($id);
        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not Found'], 404);
        }

        $data->delete();
        return response()->json(['status' => true, 'message' => 'Deleted successfully']);
    }
}
