<?php

// app/Http/Controllers/DiscUnitController.php

namespace App\Http\Controllers;

use App\Models\DiscUnit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscUnitController extends Controller
{
    public function index()
    {
        return response()->json(DiscUnit::all());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Disc_Unit_Desc' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = DiscUnit::create($request->all());

        return response()->json(['status' => true, 'data' => $data], 201);
    }

    public function show($id)
    {
        $data = DiscUnit::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function update(Request $request, $id)
    {
        $data = DiscUnit::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Disc_Unit_Desc' => 'sometimes|nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data->update($request->all());

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function destroy($id)
    {
        $data = DiscUnit::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $data->delete();

        return response()->json(['status' => true, 'message' => 'Deleted']);
    }
}
