<?php


namespace App\Http\Controllers;

use App\Models\DiscCrieteria;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscCrieteriaController extends Controller
{
    public function index()
    {
        return response()->json(DiscCrieteria::all());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'DiscountCriteria' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data = DiscCrieteria::create($request->all());

        return response()->json(['status' => true, 'data' => $data], 201);
    }

    public function show($id)
    {
        $data = DiscCrieteria::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function update(Request $request, $id)
    {
        $data = DiscCrieteria::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'DiscountCriteria' => 'sometimes|nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'errors' => $validator->errors()], 422);
        }

        $data->update($request->all());

        return response()->json(['status' => true, 'data' => $data]);
    }

    public function destroy($id)
    {
        $data = DiscCrieteria::find($id);

        if (!$data) {
            return response()->json(['status' => false, 'message' => 'Not found'], 404);
        }

        $data->delete();

        return response()->json(['status' => true, 'message' => 'Deleted']);
    }
}
