<?php


namespace App\Http\Controllers;

use App\Models\DiscCondMast;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiscCondMastController extends Controller
{

    public function index()
    {
        return response()->json(DiscCondMast::all(), 200);
    }

    public function show($id)
    {
        $data = DiscCondMast::find($id);
        if (!$data) {
            return response()->json(['message' => 'Not found'], 404);
        }
        return response()->json($data);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'DiscCondDesc' => 'nullable|string',
            'DiscC_Value' => 'nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $data = DiscCondMast::create($validator->validated());
        return response()->json(['message' => 'Created', 'data' => $data], 201);
    }

    public function update(Request $request, $id)
    {
        $data = DiscCondMast::find($id);
        if (!$data) {
            return response()->json(['message' => 'Not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'DiscCondDesc' => 'sometimes|nullable|string',
            'DiscC_Value' => 'sometimes|nullable|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $data->update($validator->validated());
        return response()->json(['message' => 'Updated', 'data' => $data]);
    }

    public function destroy($id)
    {
        $deleted = DiscCondMast::destroy($id);
        if ($deleted) {
            return response()->json(['message' => 'Deleted']);
        }
        return response()->json(['message' => 'Not found'], 404);
    }
}
