<?php

namespace App\Http\Controllers;

use App\Models\BdgtSpent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use Throwable;

class BdgtSpentController extends Controller
{
    public function index()
    {
        try {
            return response()->json(BdgtSpent::with('taskBdgt')->get(), 200);
        } catch (Throwable $e) {
            Log::error('BdgtSpent Index Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch data'], 500);
        }
    }

    public function store(Request $request)
    {
        try {
            $data = $request->validate([
                'task_bdgt_id' => 'required|exists:task_bdgts,id',
                'Spnt_Amount'  => 'required|numeric',
                'Spnt_Date'    => 'nullable|date',
            ]);

            $spent = BdgtSpent::create($data);

            return response()->json(['message' => 'Record created', 'data' => $spent], 201);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('BdgtSpent Store Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to create'], 500);
        }
    }

    public function show($id)
    {
        try {
            $spent = BdgtSpent::with('taskBdgt')->find($id);
            if (!$spent) return response()->json(['message' => 'Not found'], 404);
            return response()->json($spent, 200);
        } catch (Throwable $e) {
            Log::error('BdgtSpent Show Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch record'], 500);
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $spent = BdgtSpent::find($id);
            if (!$spent) return response()->json(['message' => 'Not found'], 404);

            $data = $request->validate([
                'task_bdgt_id' => 'sometimes|nullable|exists:task_bdgts,id',
                'Spnt_Amount'  => 'sometimes|nullable|numeric',
                'Spnt_Date'    => 'sometimes|nullable|date',
            ]);

            $spent->update($data);

            return response()->json(['message' => 'Updated', 'data' => $spent], 200);
        } catch (ValidationException $e) {
            return response()->json(['errors' => $e->errors()], 422);
        } catch (Throwable $e) {
            Log::error('BdgtSpent Update Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to update'], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $spent = BdgtSpent::find($id);
            if (!$spent) return response()->json(['message' => 'Not found'], 404);

            $spent->delete();
            return response()->json(['message' => 'Deleted'], 200);
        } catch (Throwable $e) {
            Log::error('BdgtSpent Delete Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to delete'], 500);
        }
    }
}
